/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.GrantConstraints;

@SdkInternalApi
public class GrantConstraintsMarshaller {
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTSUBSET_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextSubset").build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTEQUALS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextEquals").build();
    private static final GrantConstraintsMarshaller instance = new GrantConstraintsMarshaller();

    public static GrantConstraintsMarshaller getInstance() {
        return instance;
    }

    public void marshall(GrantConstraints grantConstraints, ProtocolMarshaller protocolMarshaller) {
        if (grantConstraints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(grantConstraints.encryptionContextSubset(), ENCRYPTIONCONTEXTSUBSET_BINDING);
            protocolMarshaller.marshall(grantConstraints.encryptionContextEquals(), ENCRYPTIONCONTEXTEQUALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

