/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.transform.GrantConstraintsUnmarshaller;

public class GrantListEntryUnmarshaller
implements Unmarshaller<GrantListEntry, JsonUnmarshallerContext> {
    private static GrantListEntryUnmarshaller INSTANCE;

    @Override
    public GrantListEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        GrantListEntry.Builder grantListEntryBuilder = GrantListEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.keyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("GrantId", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.grantId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.creationDate(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("GranteePrincipal", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.granteePrincipal(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RetiringPrincipal", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.retiringPrincipal(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IssuingAccount", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.issuingAccount(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Operations", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.operations(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Constraints", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.constraints(GrantConstraintsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GrantListEntry)grantListEntryBuilder.build();
    }

    public static GrantListEntryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GrantListEntryUnmarshaller();
        }
        return INSTANCE;
    }
}

