/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;

@SdkInternalApi
public class RevokeGrantRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<String> GRANTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantId").build();
    private static final RevokeGrantRequestModelMarshaller instance = new RevokeGrantRequestModelMarshaller();

    public static RevokeGrantRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(RevokeGrantRequest revokeGrantRequest, ProtocolMarshaller protocolMarshaller) {
        if (revokeGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(revokeGrantRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall(revokeGrantRequest.grantId(), GRANTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

