/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.ResetException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.internal.Aws4SignerRequestParams;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3.auth.AwsChunkedEncodingInputStream;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Validate;

public class AwsS3V4Signer
extends Aws4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final String CONTENT_LENGTH = "Content-Length";
    private Boolean disableChunkedEncoding;
    private Boolean enablePayloadSigning;

    public AwsS3V4Signer() {
        super(false);
    }

    @Override
    protected void processRequestPayload(SdkHttpFullRequest.Builder request, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams) {
        if (this.useChunkEncoding(request)) {
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(request.getContent(), signingKey, signerRequestParams.getFormattedSigningDateTime(), signerRequestParams.getScope(), BinaryUtils.toHex(signature), this);
            request.content(chunkEncodededStream);
        }
    }

    @Override
    protected String calculateContentHashPresign(SdkHttpFullRequest.Builder request) {
        return UNSIGNED_PAYLOAD;
    }

    @Override
    protected String calculateContentHash(SdkHttpFullRequest.Builder request) {
        request.header("x-amz-content-sha256", "required");
        if (this.isPayloadSigningEnabled(request)) {
            if (this.useChunkEncoding(request)) {
                long originalContentLength;
                String contentLength = request.getFirstHeaderValue(CONTENT_LENGTH).orElse(null);
                if (contentLength != null) {
                    originalContentLength = Long.parseLong(contentLength);
                } else {
                    try {
                        originalContentLength = AwsS3V4Signer.getContentLength(request);
                    }
                    catch (IOException e) {
                        throw new SdkClientException("Cannot get the content-length of the request content.", e);
                    }
                }
                request.header("x-amz-decoded-content-length", Long.toString(originalContentLength));
                request.header(CONTENT_LENGTH, Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
                return CONTENT_SHA_256;
            }
            return super.calculateContentHash(request);
        }
        return UNSIGNED_PAYLOAD;
    }

    private boolean useChunkEncoding(SdkHttpRequest request) {
        if (!this.isPayloadSigningEnabled(request) || this.isChunkedEncodingDisabled()) {
            return false;
        }
        Object originalRequest = request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG).getOriginalRequest();
        return originalRequest instanceof PutObjectRequest || originalRequest instanceof UploadPartRequest;
    }

    private boolean isChunkedEncodingDisabled() {
        return this.disableChunkedEncoding != null && this.disableChunkedEncoding != false;
    }

    private boolean isPayloadSigningEnabled(SdkHttpRequest request) {
        if (!request.getEndpoint().getScheme().equals("https")) {
            return true;
        }
        return this.enablePayloadSigning != null && this.enablePayloadSigning != false;
    }

    private static long getContentLength(SdkHttpFullRequest.Builder request) throws IOException {
        int read;
        InputStream content = request.getContent();
        Validate.validState(content.markSupported(), "Request input stream must have been made mark-and-resettable", new Object[0]);
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        content.mark(AwsS3V4Signer.getReadLimit(request));
        while ((read = content.read(tmp)) != -1) {
            contentLength += (long)read;
        }
        try {
            content.reset();
        }
        catch (IOException ex) {
            throw new ResetException("Failed to reset the input stream", ex);
        }
        return contentLength;
    }

    @ReviewBeforeRelease(value="Create a builder for signers and set this in it. Also currently unexercised")
    public void setDisableChunkedEncoding(boolean disableChunkedEncoding) {
        this.disableChunkedEncoding = disableChunkedEncoding;
    }

    @ReviewBeforeRelease(value="Create a builder for signers and set this in it. Also currently unexercised.")
    public void setEnablePayloadSigning(boolean enablePayloadSigning) {
        this.enablePayloadSigning = enablePayloadSigning;
    }
}

