/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.s3.AwsS3V4Signer;
import software.amazon.awssdk.services.s3.S3AdvancedConfiguration;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3ServiceEndpointBuilder;
import software.amazon.awssdk.services.s3.auth.S3SignerProvider;

@SdkInternalApi
abstract class DefaultS3BaseClientBuilder<B extends S3BaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    private S3AdvancedConfiguration advancedConfiguration;

    DefaultS3BaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "s3";
    }

    @Override
    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/s3/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        AwsS3V4Signer signer = new AwsS3V4Signer();
        signer.setServiceName("s3");
        signer.setRegionName(this.signingRegion().value());
        return new S3SignerProvider(signer);
    }

    private URI defaultEndpoint() {
        return S3ServiceEndpointBuilder.getEndpoint(this.advancedConfiguration, this.resolveRegion().get());
    }

    public B advancedConfiguration(S3AdvancedConfiguration advancedConfiguration) {
        this.advancedConfiguration = advancedConfiguration;
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    protected S3AdvancedConfiguration advancedConfiguration() {
        return this.advancedConfiguration;
    }

    public void setAdvancedConfiguration(S3AdvancedConfiguration advancedConfiguration) {
        this.advancedConfiguration(advancedConfiguration);
    }
}

