/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.services.s3.BucketUtils;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public class CreateBucketRequestHandler
extends RequestHandler {
    @Override
    @ReviewBeforeRelease(value="Automatically set location constraint to the bucket region if not provided. Also perhaps remove the location constraint from the model so that is may only be the current region.")
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        if (request instanceof CreateBucketRequest) {
            CreateBucketRequest createBucketRequest = (CreateBucketRequest)request;
            this.validateBucketNameIsS3Compatible(createBucketRequest.bucket());
        }
        return request;
    }

    private void validateBucketNameIsS3Compatible(String bucketName) {
        BucketUtils.isValidDnsBucketName(bucketName, true);
    }
}

