/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.AllowedHeadersCopier;
import software.amazon.awssdk.services.s3.model.AllowedMethodsCopier;
import software.amazon.awssdk.services.s3.model.AllowedOriginsCopier;
import software.amazon.awssdk.services.s3.model.ExposeHeadersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CORSRule
implements ToCopyableBuilder<Builder, CORSRule> {
    private final List<String> allowedHeaders;
    private final List<String> allowedMethods;
    private final List<String> allowedOrigins;
    private final List<String> exposeHeaders;
    private final Integer maxAgeSeconds;

    private CORSRule(BuilderImpl builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.allowedMethods = builder.allowedMethods;
        this.allowedOrigins = builder.allowedOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allowedHeaders() == null ? 0 : this.allowedHeaders().hashCode());
        hashCode = 31 * hashCode + (this.allowedMethods() == null ? 0 : this.allowedMethods().hashCode());
        hashCode = 31 * hashCode + (this.allowedOrigins() == null ? 0 : this.allowedOrigins().hashCode());
        hashCode = 31 * hashCode + (this.exposeHeaders() == null ? 0 : this.exposeHeaders().hashCode());
        hashCode = 31 * hashCode + (this.maxAgeSeconds() == null ? 0 : this.maxAgeSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CORSRule)) {
            return false;
        }
        CORSRule other = (CORSRule)obj;
        if (other.allowedHeaders() == null ^ this.allowedHeaders() == null) {
            return false;
        }
        if (other.allowedHeaders() != null && !other.allowedHeaders().equals(this.allowedHeaders())) {
            return false;
        }
        if (other.allowedMethods() == null ^ this.allowedMethods() == null) {
            return false;
        }
        if (other.allowedMethods() != null && !other.allowedMethods().equals(this.allowedMethods())) {
            return false;
        }
        if (other.allowedOrigins() == null ^ this.allowedOrigins() == null) {
            return false;
        }
        if (other.allowedOrigins() != null && !other.allowedOrigins().equals(this.allowedOrigins())) {
            return false;
        }
        if (other.exposeHeaders() == null ^ this.exposeHeaders() == null) {
            return false;
        }
        if (other.exposeHeaders() != null && !other.exposeHeaders().equals(this.exposeHeaders())) {
            return false;
        }
        if (other.maxAgeSeconds() == null ^ this.maxAgeSeconds() == null) {
            return false;
        }
        return other.maxAgeSeconds() == null || other.maxAgeSeconds().equals(this.maxAgeSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedHeaders() != null) {
            sb.append("AllowedHeaders: ").append(this.allowedHeaders()).append(",");
        }
        if (this.allowedMethods() != null) {
            sb.append("AllowedMethods: ").append(this.allowedMethods()).append(",");
        }
        if (this.allowedOrigins() != null) {
            sb.append("AllowedOrigins: ").append(this.allowedOrigins()).append(",");
        }
        if (this.exposeHeaders() != null) {
            sb.append("ExposeHeaders: ").append(this.exposeHeaders()).append(",");
        }
        if (this.maxAgeSeconds() != null) {
            sb.append("MaxAgeSeconds: ").append(this.maxAgeSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> allowedHeaders;
        private List<String> allowedMethods;
        private List<String> allowedOrigins;
        private List<String> exposeHeaders;
        private Integer maxAgeSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CORSRule model) {
            this.setAllowedHeaders(model.allowedHeaders);
            this.setAllowedMethods(model.allowedMethods);
            this.setAllowedOrigins(model.allowedOrigins);
            this.setExposeHeaders(model.exposeHeaders);
            this.setMaxAgeSeconds(model.maxAgeSeconds);
        }

        public final Collection<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String ... allowedHeaders) {
            if (this.allowedHeaders == null) {
                this.allowedHeaders = new ArrayList<String>(allowedHeaders.length);
            }
            for (String e : allowedHeaders) {
                this.allowedHeaders.add(e);
            }
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        @SafeVarargs
        public final void setAllowedHeaders(String ... allowedHeaders) {
            if (this.allowedHeaders == null) {
                this.allowedHeaders = new ArrayList<String>(allowedHeaders.length);
            }
            for (String e : allowedHeaders) {
                this.allowedHeaders.add(e);
            }
        }

        public final Collection<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final Builder allowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(String ... allowedMethods) {
            if (this.allowedMethods == null) {
                this.allowedMethods = new ArrayList<String>(allowedMethods.length);
            }
            for (String e : allowedMethods) {
                this.allowedMethods.add(e);
            }
            return this;
        }

        public final void setAllowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        @SafeVarargs
        public final void setAllowedMethods(String ... allowedMethods) {
            if (this.allowedMethods == null) {
                this.allowedMethods = new ArrayList<String>(allowedMethods.length);
            }
            for (String e : allowedMethods) {
                this.allowedMethods.add(e);
            }
        }

        public final Collection<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String ... allowedOrigins) {
            if (this.allowedOrigins == null) {
                this.allowedOrigins = new ArrayList<String>(allowedOrigins.length);
            }
            for (String e : allowedOrigins) {
                this.allowedOrigins.add(e);
            }
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        @SafeVarargs
        public final void setAllowedOrigins(String ... allowedOrigins) {
            if (this.allowedOrigins == null) {
                this.allowedOrigins = new ArrayList<String>(allowedOrigins.length);
            }
            for (String e : allowedOrigins) {
                this.allowedOrigins.add(e);
            }
        }

        public final Collection<String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            if (this.exposeHeaders == null) {
                this.exposeHeaders = new ArrayList<String>(exposeHeaders.length);
            }
            for (String e : exposeHeaders) {
                this.exposeHeaders.add(e);
            }
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        @SafeVarargs
        public final void setExposeHeaders(String ... exposeHeaders) {
            if (this.exposeHeaders == null) {
                this.exposeHeaders = new ArrayList<String>(exposeHeaders.length);
            }
            for (String e : exposeHeaders) {
                this.exposeHeaders.add(e);
            }
        }

        public final Integer getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        @Override
        public CORSRule build() {
            return new CORSRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CORSRule> {
        public Builder allowedHeaders(Collection<String> var1);

        public Builder allowedHeaders(String ... var1);

        public Builder allowedMethods(Collection<String> var1);

        public Builder allowedMethods(String ... var1);

        public Builder allowedOrigins(Collection<String> var1);

        public Builder allowedOrigins(String ... var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);

        public Builder maxAgeSeconds(Integer var1);
    }
}

