/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CompletedPartListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompletedMultipartUpload
implements ToCopyableBuilder<Builder, CompletedMultipartUpload> {
    private final List<CompletedPart> parts;

    private CompletedMultipartUpload(BuilderImpl builder) {
        this.parts = builder.parts;
    }

    public List<CompletedPart> parts() {
        return this.parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parts() == null ? 0 : this.parts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload other = (CompletedMultipartUpload)obj;
        if (other.parts() == null ^ this.parts() == null) {
            return false;
        }
        return other.parts() == null || other.parts().equals(this.parts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parts() != null) {
            sb.append("Parts: ").append(this.parts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CompletedPart> parts;

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedMultipartUpload model) {
            this.setParts(model.parts);
        }

        public final Collection<CompletedPart> getParts() {
            return this.parts;
        }

        @Override
        public final Builder parts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompletedPart ... parts) {
            if (this.parts == null) {
                this.parts = new ArrayList<CompletedPart>(parts.length);
            }
            for (CompletedPart e : parts) {
                this.parts.add(e);
            }
            return this;
        }

        public final void setParts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
        }

        @SafeVarargs
        public final void setParts(CompletedPart ... parts) {
            if (this.parts == null) {
                this.parts = new ArrayList<CompletedPart>(parts.length);
            }
            for (CompletedPart e : parts) {
                this.parts.add(e);
            }
        }

        @Override
        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompletedMultipartUpload> {
        public Builder parts(Collection<CompletedPart> var1);

        public Builder parts(CompletedPart ... var1);
    }
}

