/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum Event {
    S3ReducedRedundancyLostObject("s3:ReducedRedundancyLostObject"),
    S3ObjectCreated("s3:ObjectCreated:*"),
    S3ObjectCreatedPut("s3:ObjectCreated:Put"),
    S3ObjectCreatedPost("s3:ObjectCreated:Post"),
    S3ObjectCreatedCopy("s3:ObjectCreated:Copy"),
    S3ObjectCreatedCompleteMultipartUpload("s3:ObjectCreated:CompleteMultipartUpload"),
    S3ObjectRemoved("s3:ObjectRemoved:*"),
    S3ObjectRemovedDelete("s3:ObjectRemoved:Delete"),
    S3ObjectRemovedDeleteMarkerCreated("s3:ObjectRemoved:DeleteMarkerCreated");

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static Event fromValue(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(Event.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

