/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CORSRule;
import software.amazon.awssdk.services.s3.model.CORSRulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketCorsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBucketCorsResponse> {
    private final List<CORSRule> corsRules;

    private GetBucketCorsResponse(BuilderImpl builder) {
        this.corsRules = builder.corsRules;
    }

    public List<CORSRule> corsRules() {
        return this.corsRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.corsRules() == null ? 0 : this.corsRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketCorsResponse)) {
            return false;
        }
        GetBucketCorsResponse other = (GetBucketCorsResponse)obj;
        if (other.corsRules() == null ^ this.corsRules() == null) {
            return false;
        }
        return other.corsRules() == null || other.corsRules().equals(this.corsRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.corsRules() != null) {
            sb.append("CORSRules: ").append(this.corsRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CORSRule> corsRules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketCorsResponse model) {
            this.setCORSRules(model.corsRules);
        }

        public final Collection<CORSRule> getCORSRules() {
            return this.corsRules;
        }

        @Override
        public final Builder corsRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsRules(CORSRule ... corsRules) {
            if (this.corsRules == null) {
                this.corsRules = new ArrayList<CORSRule>(corsRules.length);
            }
            for (CORSRule e : corsRules) {
                this.corsRules.add(e);
            }
            return this;
        }

        public final void setCORSRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
        }

        @SafeVarargs
        public final void setCORSRules(CORSRule ... corsRules) {
            if (this.corsRules == null) {
                this.corsRules = new ArrayList<CORSRule>(corsRules.length);
            }
            for (CORSRule e : corsRules) {
                this.corsRules.add(e);
            }
        }

        @Override
        public GetBucketCorsResponse build() {
            return new GetBucketCorsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBucketCorsResponse> {
        public Builder corsRules(Collection<CORSRule> var1);

        public Builder corsRules(CORSRule ... var1);
    }
}

