/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.TagSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketTaggingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBucketTaggingResponse> {
    private final List<Tag> tagSet;

    private GetBucketTaggingResponse(BuilderImpl builder) {
        this.tagSet = builder.tagSet;
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagSet() == null ? 0 : this.tagSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketTaggingResponse)) {
            return false;
        }
        GetBucketTaggingResponse other = (GetBucketTaggingResponse)obj;
        if (other.tagSet() == null ^ this.tagSet() == null) {
            return false;
        }
        return other.tagSet() == null || other.tagSet().equals(this.tagSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tagSet() != null) {
            sb.append("TagSet: ").append(this.tagSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Tag> tagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketTaggingResponse model) {
            this.setTagSet(model.tagSet);
        }

        public final Collection<Tag> getTagSet() {
            return this.tagSet;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            if (this.tagSet == null) {
                this.tagSet = new ArrayList<Tag>(tagSet.length);
            }
            for (Tag e : tagSet) {
                this.tagSet.add(e);
            }
            return this;
        }

        public final void setTagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
        }

        @SafeVarargs
        public final void setTagSet(Tag ... tagSet) {
            if (this.tagSet == null) {
                this.tagSet = new ArrayList<Tag>(tagSet.length);
            }
            for (Tag e : tagSet) {
                this.tagSet.add(e);
            }
        }

        @Override
        public GetBucketTaggingResponse build() {
            return new GetBucketTaggingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBucketTaggingResponse> {
        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);
    }
}

