/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketMetricsConfigurationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListBucketMetricsConfigurationsRequest> {
    private final String bucket;
    private final String continuationToken;

    private ListBucketMetricsConfigurationsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
    }

    public String bucket() {
        return this.bucket;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketMetricsConfigurationsRequest)) {
            return false;
        }
        ListBucketMetricsConfigurationsRequest other = (ListBucketMetricsConfigurationsRequest)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        return other.continuationToken() == null || other.continuationToken().equals(this.continuationToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketMetricsConfigurationsRequest model) {
            this.setBucket(model.bucket);
            this.setContinuationToken(model.continuationToken);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public ListBucketMetricsConfigurationsRequest build() {
            return new ListBucketMetricsConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketMetricsConfigurationsRequest> {
        public Builder bucket(String var1);

        public Builder continuationToken(String var1);
    }
}

