/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.BucketsCopier;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBucketsResponse> {
    private final List<Bucket> buckets;
    private final Owner owner;

    private ListBucketsResponse(BuilderImpl builder) {
        this.buckets = builder.buckets;
        this.owner = builder.owner;
    }

    public List<Bucket> buckets() {
        return this.buckets;
    }

    public Owner owner() {
        return this.owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.buckets() == null ? 0 : this.buckets().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsResponse)) {
            return false;
        }
        ListBucketsResponse other = (ListBucketsResponse)obj;
        if (other.buckets() == null ^ this.buckets() == null) {
            return false;
        }
        if (other.buckets() != null && !other.buckets().equals(this.buckets())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        return other.owner() == null || other.owner().equals(this.owner());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buckets() != null) {
            sb.append("Buckets: ").append(this.buckets()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Bucket> buckets;
        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsResponse model) {
            this.setBuckets(model.buckets);
            this.setOwner(model.owner);
        }

        public final Collection<Bucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            if (this.buckets == null) {
                this.buckets = new ArrayList<Bucket>(buckets.length);
            }
            for (Bucket e : buckets) {
                this.buckets.add(e);
            }
            return this;
        }

        public final void setBuckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
        }

        @SafeVarargs
        public final void setBuckets(Bucket ... buckets) {
            if (this.buckets == null) {
                this.buckets = new ArrayList<Bucket>(buckets.length);
            }
            for (Bucket e : buckets) {
                this.buckets.add(e);
            }
        }

        public final Owner getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        @Override
        public ListBucketsResponse build() {
            return new ListBucketsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketsResponse> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);

        public Builder owner(Owner var1);
    }
}

