/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ObjectCannedACL {
    Private("private"),
    PublicRead("public-read"),
    PublicReadWrite("public-read-write"),
    AuthenticatedRead("authenticated-read"),
    AwsExecRead("aws-exec-read"),
    BucketOwnerRead("bucket-owner-read"),
    BucketOwnerFullControl("bucket-owner-full-control");

    private final String value;

    private ObjectCannedACL(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ObjectCannedACL fromValue(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ObjectCannedACL.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

