/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketNotificationConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketNotificationConfigurationRequest> {
    private final String bucket;
    private final NotificationConfiguration notificationConfiguration;

    private PutBucketNotificationConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfiguration() == null ? 0 : this.notificationConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketNotificationConfigurationRequest)) {
            return false;
        }
        PutBucketNotificationConfigurationRequest other = (PutBucketNotificationConfigurationRequest)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.notificationConfiguration() == null ^ this.notificationConfiguration() == null) {
            return false;
        }
        return other.notificationConfiguration() == null || other.notificationConfiguration().equals(this.notificationConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.notificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.notificationConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketNotificationConfigurationRequest model) {
            this.setBucket(model.bucket);
            this.setNotificationConfiguration(model.notificationConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final NotificationConfiguration getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
        }

        @Override
        public PutBucketNotificationConfigurationRequest build() {
            return new PutBucketNotificationConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketNotificationConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);
    }
}

