/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationDeprecated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketNotificationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketNotificationRequest> {
    private final String bucket;
    private final String contentMD5;
    private final NotificationConfigurationDeprecated notificationConfiguration;

    private PutBucketNotificationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public NotificationConfigurationDeprecated notificationConfiguration() {
        return this.notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfiguration() == null ? 0 : this.notificationConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketNotificationRequest)) {
            return false;
        }
        PutBucketNotificationRequest other = (PutBucketNotificationRequest)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.notificationConfiguration() == null ^ this.notificationConfiguration() == null) {
            return false;
        }
        return other.notificationConfiguration() == null || other.notificationConfiguration().equals(this.notificationConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.notificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.notificationConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private NotificationConfigurationDeprecated notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketNotificationRequest model) {
            this.setBucket(model.bucket);
            this.setContentMD5(model.contentMD5);
            this.setNotificationConfiguration(model.notificationConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final NotificationConfigurationDeprecated getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfigurationDeprecated notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfigurationDeprecated notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
        }

        @Override
        public PutBucketNotificationRequest build() {
            return new PutBucketNotificationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketNotificationRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder notificationConfiguration(NotificationConfigurationDeprecated var1);
    }
}

