/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketVersioningRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketVersioningRequest> {
    private final String bucket;
    private final String contentMD5;
    private final String mfa;
    private final VersioningConfiguration versioningConfiguration;

    private PutBucketVersioningRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.mfa = builder.mfa;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String mfa() {
        return this.mfa;
    }

    public VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        hashCode = 31 * hashCode + (this.mfa() == null ? 0 : this.mfa().hashCode());
        hashCode = 31 * hashCode + (this.versioningConfiguration() == null ? 0 : this.versioningConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketVersioningRequest)) {
            return false;
        }
        PutBucketVersioningRequest other = (PutBucketVersioningRequest)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.mfa() == null ^ this.mfa() == null) {
            return false;
        }
        if (other.mfa() != null && !other.mfa().equals(this.mfa())) {
            return false;
        }
        if (other.versioningConfiguration() == null ^ this.versioningConfiguration() == null) {
            return false;
        }
        return other.versioningConfiguration() == null || other.versioningConfiguration().equals(this.versioningConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.mfa() != null) {
            sb.append("MFA: ").append(this.mfa()).append(",");
        }
        if (this.versioningConfiguration() != null) {
            sb.append("VersioningConfiguration: ").append(this.versioningConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private String mfa;
        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketVersioningRequest model) {
            this.setBucket(model.bucket);
            this.setContentMD5(model.contentMD5);
            this.setMFA(model.mfa);
            this.setVersioningConfiguration(model.versioningConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getMFA() {
            return this.mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMFA(String mfa) {
            this.mfa = mfa;
        }

        public final VersioningConfiguration getVersioningConfiguration() {
            return this.versioningConfiguration;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
        }

        @Override
        public PutBucketVersioningRequest build() {
            return new PutBucketVersioningRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketVersioningRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder mfa(String var1);

        public Builder versioningConfiguration(VersioningConfiguration var1);
    }
}

