/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.GlacierJobParameters;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreRequest
implements ToCopyableBuilder<Builder, RestoreRequest> {
    private final Integer days;
    private final GlacierJobParameters glacierJobParameters;

    private RestoreRequest(BuilderImpl builder) {
        this.days = builder.days;
        this.glacierJobParameters = builder.glacierJobParameters;
    }

    public Integer days() {
        return this.days;
    }

    public GlacierJobParameters glacierJobParameters() {
        return this.glacierJobParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.days() == null ? 0 : this.days().hashCode());
        hashCode = 31 * hashCode + (this.glacierJobParameters() == null ? 0 : this.glacierJobParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreRequest)) {
            return false;
        }
        RestoreRequest other = (RestoreRequest)obj;
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.glacierJobParameters() == null ^ this.glacierJobParameters() == null) {
            return false;
        }
        return other.glacierJobParameters() == null || other.glacierJobParameters().equals(this.glacierJobParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.days() != null) {
            sb.append("Days: ").append(this.days()).append(",");
        }
        if (this.glacierJobParameters() != null) {
            sb.append("GlacierJobParameters: ").append(this.glacierJobParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer days;
        private GlacierJobParameters glacierJobParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreRequest model) {
            this.setDays(model.days);
            this.setGlacierJobParameters(model.glacierJobParameters);
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final GlacierJobParameters getGlacierJobParameters() {
            return this.glacierJobParameters;
        }

        @Override
        public final Builder glacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
            return this;
        }

        public final void setGlacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
        }

        @Override
        public RestoreRequest build() {
            return new RestoreRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreRequest> {
        public Builder days(Integer var1);

        public Builder glacierJobParameters(GlacierJobParameters var1);
    }
}

