/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.FilterRule;
import software.amazon.awssdk.services.s3.model.FilterRuleListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3KeyFilter
implements ToCopyableBuilder<Builder, S3KeyFilter> {
    private final List<FilterRule> filterRules;

    private S3KeyFilter(BuilderImpl builder) {
        this.filterRules = builder.filterRules;
    }

    public List<FilterRule> filterRules() {
        return this.filterRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filterRules() == null ? 0 : this.filterRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyFilter)) {
            return false;
        }
        S3KeyFilter other = (S3KeyFilter)obj;
        if (other.filterRules() == null ^ this.filterRules() == null) {
            return false;
        }
        return other.filterRules() == null || other.filterRules().equals(this.filterRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filterRules() != null) {
            sb.append("FilterRules: ").append(this.filterRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FilterRule> filterRules;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KeyFilter model) {
            this.setFilterRules(model.filterRules);
        }

        public final Collection<FilterRule> getFilterRules() {
            return this.filterRules;
        }

        @Override
        public final Builder filterRules(Collection<FilterRule> filterRules) {
            this.filterRules = FilterRuleListCopier.copy(filterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterRules(FilterRule ... filterRules) {
            if (this.filterRules == null) {
                this.filterRules = new ArrayList<FilterRule>(filterRules.length);
            }
            for (FilterRule e : filterRules) {
                this.filterRules.add(e);
            }
            return this;
        }

        public final void setFilterRules(Collection<FilterRule> filterRules) {
            this.filterRules = FilterRuleListCopier.copy(filterRules);
        }

        @SafeVarargs
        public final void setFilterRules(FilterRule ... filterRules) {
            if (this.filterRules == null) {
                this.filterRules = new ArrayList<FilterRule>(filterRules.length);
            }
            for (FilterRule e : filterRules) {
                this.filterRules.add(e);
            }
        }

        @Override
        public S3KeyFilter build() {
            return new S3KeyFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3KeyFilter> {
        public Builder filterRules(Collection<FilterRule> var1);

        public Builder filterRules(FilterRule ... var1);
    }
}

