/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AnalyticsAndOperator;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class AnalyticsAndOperatorUnmarshaller
implements Unmarshaller<AnalyticsAndOperator, StaxUnmarshallerContext> {
    private static AnalyticsAndOperatorUnmarshaller INSTANCE;

    @Override
    public AnalyticsAndOperator unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AnalyticsAndOperator.Builder analyticsAndOperator = AnalyticsAndOperator.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Prefix", targetDepth)) {
                    analyticsAndOperator.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Tag", targetDepth)) continue;
                analyticsAndOperator.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AnalyticsAndOperator)analyticsAndOperator.build();
    }

    public static AnalyticsAndOperatorUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsAndOperatorUnmarshaller();
        }
        return INSTANCE;
    }
}

