/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.BucketLoggingStatus;
import software.amazon.awssdk.services.s3.transform.LoggingEnabledUnmarshaller;

public class BucketLoggingStatusUnmarshaller
implements Unmarshaller<BucketLoggingStatus, StaxUnmarshallerContext> {
    private static BucketLoggingStatusUnmarshaller INSTANCE;

    @Override
    public BucketLoggingStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BucketLoggingStatus.Builder bucketLoggingStatus = BucketLoggingStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("LoggingEnabled", targetDepth)) continue;
                bucketLoggingStatus.loggingEnabled(LoggingEnabledUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BucketLoggingStatus)bucketLoggingStatus.build();
    }

    public static BucketLoggingStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BucketLoggingStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

