/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CORSRule;

public class CORSRuleUnmarshaller
implements Unmarshaller<CORSRule, StaxUnmarshallerContext> {
    private static CORSRuleUnmarshaller INSTANCE;

    @Override
    public CORSRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CORSRule.Builder corsRule = CORSRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AllowedHeader", targetDepth)) {
                    corsRule.allowedHeaders(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedMethod", targetDepth)) {
                    corsRule.allowedMethods(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedOrigin", targetDepth)) {
                    corsRule.allowedOrigins(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExposeHeader", targetDepth)) {
                    corsRule.exposeHeaders(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MaxAgeSeconds", targetDepth)) continue;
                corsRule.maxAgeSeconds(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CORSRule)corsRule.build();
    }

    public static CORSRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CORSRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

