/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import java.util.List;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class CompleteMultipartUploadRequestMarshaller
implements Marshaller<Request<CompleteMultipartUploadRequest>, CompleteMultipartUploadRequest> {
    @Override
    public Request<CompleteMultipartUploadRequest> marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        if (completeMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CompleteMultipartUploadRequest> request = new DefaultRequest<CompleteMultipartUploadRequest>(completeMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeMultipartUploadRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(completeMultipartUploadRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", completeMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", completeMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        if (completeMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(completeMultipartUploadRequest.uploadId()));
        }
        try {
            StringWriter stringWriter = null;
            CompletedMultipartUpload multipartUpload = completeMultipartUploadRequest.multipartUpload();
            if (multipartUpload != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CompleteMultipartUpload");
                List<CompletedPart> completedMultipartUploadPartsList = multipartUpload.parts();
                if (completedMultipartUploadPartsList != null) {
                    for (CompletedPart completedMultipartUploadPartsListValue : completedMultipartUploadPartsList) {
                        xmlWriter.startElement("Part");
                        if (completedMultipartUploadPartsListValue.eTag() != null) {
                            xmlWriter.startElement("ETag").value(completedMultipartUploadPartsListValue.eTag()).endElement();
                        }
                        if (completedMultipartUploadPartsListValue.partNumber() != null) {
                            xmlWriter.startElement("PartNumber").value(completedMultipartUploadPartsListValue.partNumber()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

