/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Condition;

public class ConditionUnmarshaller
implements Unmarshaller<Condition, StaxUnmarshallerContext> {
    private static ConditionUnmarshaller INSTANCE;

    @Override
    public Condition unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Condition.Builder condition = Condition.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HttpErrorCodeReturnedEquals", targetDepth)) {
                    condition.httpErrorCodeReturnedEquals(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyPrefixEquals", targetDepth)) continue;
                condition.keyPrefixEquals(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Condition)condition.build();
    }

    public static ConditionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConditionUnmarshaller();
        }
        return INSTANCE;
    }
}

