/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class CopyObjectRequestMarshaller
implements Marshaller<Request<CopyObjectRequest>, CopyObjectRequest> {
    @Override
    public Request<CopyObjectRequest> marshall(CopyObjectRequest copyObjectRequest) {
        if (copyObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyObjectRequest> request = new DefaultRequest<CopyObjectRequest>(copyObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (copyObjectRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(copyObjectRequest.acl()));
        }
        if (copyObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString(copyObjectRequest.cacheControl()));
        }
        if (copyObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString(copyObjectRequest.contentDisposition()));
        }
        if (copyObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString(copyObjectRequest.contentEncoding()));
        }
        if (copyObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString(copyObjectRequest.contentLanguage()));
        }
        if (copyObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(copyObjectRequest.contentType()));
        }
        if (copyObjectRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringUtils.fromString(copyObjectRequest.copySource()));
        }
        if (copyObjectRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringUtils.fromString(copyObjectRequest.copySourceIfMatch()));
        }
        if (copyObjectRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since", StringUtils.fromDate(copyObjectRequest.copySourceIfModifiedSince()));
        }
        if (copyObjectRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match", StringUtils.fromString(copyObjectRequest.copySourceIfNoneMatch()));
        }
        if (copyObjectRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since", StringUtils.fromDate(copyObjectRequest.copySourceIfUnmodifiedSince()));
        }
        if (copyObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromDate(copyObjectRequest.expires()));
        }
        if (copyObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(copyObjectRequest.grantFullControl()));
        }
        if (copyObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(copyObjectRequest.grantRead()));
        }
        if (copyObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(copyObjectRequest.grantReadACP()));
        }
        if (copyObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(copyObjectRequest.grantWriteACP()));
        }
        if (copyObjectRequest.metadataDirective() != null) {
            request.addHeader("x-amz-metadata-directive", StringUtils.fromString(copyObjectRequest.metadataDirective()));
        }
        if (copyObjectRequest.taggingDirective() != null) {
            request.addHeader("x-amz-tagging-directive", StringUtils.fromString(copyObjectRequest.taggingDirective()));
        }
        if (copyObjectRequest.serverSideEncryption() != null) {
            request.addHeader("x-amz-server-side-encryption", StringUtils.fromString(copyObjectRequest.serverSideEncryption()));
        }
        if (copyObjectRequest.storageClass() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString(copyObjectRequest.storageClass()));
        }
        if (copyObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringUtils.fromString(copyObjectRequest.websiteRedirectLocation()));
        }
        if (copyObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString(copyObjectRequest.sseCustomerAlgorithm()));
        }
        if (copyObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString(copyObjectRequest.sseCustomerKey()));
        }
        if (copyObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString(copyObjectRequest.sseCustomerKeyMD5()));
        }
        if (copyObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringUtils.fromString(copyObjectRequest.ssekmsKeyId()));
        }
        if (copyObjectRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", StringUtils.fromString(copyObjectRequest.copySourceSSECustomerAlgorithm()));
        }
        if (copyObjectRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key", StringUtils.fromString(copyObjectRequest.copySourceSSECustomerKey()));
        }
        if (copyObjectRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", StringUtils.fromString(copyObjectRequest.copySourceSSECustomerKeyMD5()));
        }
        if (copyObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(copyObjectRequest.requestPayer()));
        }
        if (copyObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString(copyObjectRequest.tagging()));
        }
        if (copyObjectRequest.metadata() != null) {
            copyObjectRequest.metadata().entrySet().forEach(e -> {
                if (((String)e.getKey()).startsWith("x-amz-meta-")) {
                    request.addHeader((String)e.getKey(), (String)e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
                }
            });
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", copyObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", copyObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

