/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.transform.CopyObjectResultUnmarshaller;

public class CopyObjectResponseUnmarshaller
implements Unmarshaller<CopyObjectResponse, StaxUnmarshallerContext> {
    private static CopyObjectResponseUnmarshaller INSTANCE;

    @Override
    public CopyObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CopyObjectResponse.Builder copyObjectResponse = CopyObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-expiration");
            copyObjectResponse.expiration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-copy-source-version-id");
            copyObjectResponse.copySourceVersionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-version-id");
            copyObjectResponse.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption");
            copyObjectResponse.serverSideEncryption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            copyObjectResponse.sseCustomerAlgorithm(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            copyObjectResponse.sseCustomerKeyMD5(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            copyObjectResponse.ssekmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            copyObjectResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("CopyObjectResult", targetDepth)) continue;
                copyObjectResponse.copyObjectResult(CopyObjectResultUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CopyObjectResponse)copyObjectResponse.build();
    }

    public static CopyObjectResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyObjectResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

