/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CopyPartResult;

public class CopyPartResultUnmarshaller
implements Unmarshaller<CopyPartResult, StaxUnmarshallerContext> {
    private static CopyPartResultUnmarshaller INSTANCE;

    @Override
    public CopyPartResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CopyPartResult.Builder copyPartResult = CopyPartResult.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ETag", targetDepth)) {
                    copyPartResult.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastModified", targetDepth)) continue;
                copyPartResult.lastModified(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CopyPartResult)copyPartResult.build();
    }

    public static CopyPartResultUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyPartResultUnmarshaller();
        }
        return INSTANCE;
    }
}

