/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class CreateBucketRequestMarshaller
implements Marshaller<Request<CreateBucketRequest>, CreateBucketRequest> {
    @Override
    public Request<CreateBucketRequest> marshall(CreateBucketRequest createBucketRequest) {
        if (createBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBucketRequest> request = new DefaultRequest<CreateBucketRequest>(createBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createBucketRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(createBucketRequest.acl()));
        }
        if (createBucketRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(createBucketRequest.grantFullControl()));
        }
        if (createBucketRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(createBucketRequest.grantRead()));
        }
        if (createBucketRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(createBucketRequest.grantReadACP()));
        }
        if (createBucketRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString(createBucketRequest.grantWrite()));
        }
        if (createBucketRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(createBucketRequest.grantWriteACP()));
        }
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", createBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            CreateBucketConfiguration createBucketConfiguration = createBucketRequest.createBucketConfiguration();
            if (createBucketConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CreateBucketConfiguration");
                if (createBucketConfiguration.locationConstraint() != null) {
                    xmlWriter.startElement("LocationConstraint").value(createBucketConfiguration.locationConstraint()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

