/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketAnalyticsConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketAnalyticsConfigurationRequest>, DeleteBucketAnalyticsConfigurationRequest> {
    @Override
    public Request<DeleteBucketAnalyticsConfigurationRequest> marshall(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) {
        if (deleteBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBucketAnalyticsConfigurationRequest> request = new DefaultRequest<DeleteBucketAnalyticsConfigurationRequest>(deleteBucketAnalyticsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?analytics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(deleteBucketAnalyticsConfigurationRequest.id()));
        }
        return request;
    }
}

