/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketLifecycleRequestMarshaller
implements Marshaller<Request<DeleteBucketLifecycleRequest>, DeleteBucketLifecycleRequest> {
    @Override
    public Request<DeleteBucketLifecycleRequest> marshall(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) {
        if (deleteBucketLifecycleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBucketLifecycleRequest> request = new DefaultRequest<DeleteBucketLifecycleRequest>(deleteBucketLifecycleRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?lifecycle";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketLifecycleRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

