/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketMetricsConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketMetricsConfigurationRequest>, DeleteBucketMetricsConfigurationRequest> {
    @Override
    public Request<DeleteBucketMetricsConfigurationRequest> marshall(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) {
        if (deleteBucketMetricsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBucketMetricsConfigurationRequest> request = new DefaultRequest<DeleteBucketMetricsConfigurationRequest>(deleteBucketMetricsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketMetricsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketMetricsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(deleteBucketMetricsConfigurationRequest.id()));
        }
        return request;
    }
}

