/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;

public class DeleteBucketRequestMarshaller
implements Marshaller<Request<DeleteBucketRequest>, DeleteBucketRequest> {
    @Override
    public Request<DeleteBucketRequest> marshall(DeleteBucketRequest deleteBucketRequest) {
        if (deleteBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBucketRequest> request = new DefaultRequest<DeleteBucketRequest>(deleteBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

