/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketTaggingRequestMarshaller
implements Marshaller<Request<DeleteBucketTaggingRequest>, DeleteBucketTaggingRequest> {
    @Override
    public Request<DeleteBucketTaggingRequest> marshall(DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        if (deleteBucketTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBucketTaggingRequest> request = new DefaultRequest<DeleteBucketTaggingRequest>(deleteBucketTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketTaggingRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

