/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteObjectTaggingRequestMarshaller
implements Marshaller<Request<DeleteObjectTaggingRequest>, DeleteObjectTaggingRequest> {
    @Override
    public Request<DeleteObjectTaggingRequest> marshall(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        if (deleteObjectTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteObjectTaggingRequest> request = new DefaultRequest<DeleteObjectTaggingRequest>(deleteObjectTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}/{Key+}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectTaggingRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", deleteObjectTaggingRequest.key());
        request.setResourcePath(uriResourcePath);
        if (deleteObjectTaggingRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(deleteObjectTaggingRequest.versionId()));
        }
        return request;
    }
}

