/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketAclRequestMarshaller
implements Marshaller<Request<GetBucketAclRequest>, GetBucketAclRequest> {
    @Override
    public Request<GetBucketAclRequest> marshall(GetBucketAclRequest getBucketAclRequest) {
        if (getBucketAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBucketAclRequest> request = new DefaultRequest<GetBucketAclRequest>(getBucketAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketAclRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

