/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketInventoryConfigurationRequest>, GetBucketInventoryConfigurationRequest> {
    @Override
    public Request<GetBucketInventoryConfigurationRequest> marshall(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) {
        if (getBucketInventoryConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBucketInventoryConfigurationRequest> request = new DefaultRequest<GetBucketInventoryConfigurationRequest>(getBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (getBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(getBucketInventoryConfigurationRequest.id()));
        }
        return request;
    }
}

