/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketLifecycleRequestMarshaller
implements Marshaller<Request<GetBucketLifecycleRequest>, GetBucketLifecycleRequest> {
    @Override
    public Request<GetBucketLifecycleRequest> marshall(GetBucketLifecycleRequest getBucketLifecycleRequest) {
        if (getBucketLifecycleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBucketLifecycleRequest> request = new DefaultRequest<GetBucketLifecycleRequest>(getBucketLifecycleRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?lifecycle";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketLifecycleRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

