/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketReplicationRequestMarshaller
implements Marshaller<Request<GetBucketReplicationRequest>, GetBucketReplicationRequest> {
    @Override
    public Request<GetBucketReplicationRequest> marshall(GetBucketReplicationRequest getBucketReplicationRequest) {
        if (getBucketReplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBucketReplicationRequest> request = new DefaultRequest<GetBucketReplicationRequest>(getBucketReplicationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?replication";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketReplicationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

