/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketVersioningRequestMarshaller
implements Marshaller<Request<GetBucketVersioningRequest>, GetBucketVersioningRequest> {
    @Override
    public Request<GetBucketVersioningRequest> marshall(GetBucketVersioningRequest getBucketVersioningRequest) {
        if (getBucketVersioningRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBucketVersioningRequest> request = new DefaultRequest<GetBucketVersioningRequest>(getBucketVersioningRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?versioning";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketVersioningRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

