/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetObjectAclRequestMarshaller
implements Marshaller<Request<GetObjectAclRequest>, GetObjectAclRequest> {
    @Override
    public Request<GetObjectAclRequest> marshall(GetObjectAclRequest getObjectAclRequest) {
        if (getObjectAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetObjectAclRequest> request = new DefaultRequest<GetObjectAclRequest>(getObjectAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectAclRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(getObjectAclRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectAclRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(getObjectAclRequest.versionId()));
        }
        return request;
    }
}

