/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetObjectTaggingRequestMarshaller
implements Marshaller<Request<GetObjectTaggingRequest>, GetObjectTaggingRequest> {
    @Override
    public Request<GetObjectTaggingRequest> marshall(GetObjectTaggingRequest getObjectTaggingRequest) {
        if (getObjectTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetObjectTaggingRequest> request = new DefaultRequest<GetObjectTaggingRequest>(getObjectTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}/{Key+}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectTaggingRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectTaggingRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectTaggingRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(getObjectTaggingRequest.versionId()));
        }
        return request;
    }
}

