/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Grantee;

public class GranteeUnmarshaller
implements Unmarshaller<Grantee, StaxUnmarshallerContext> {
    private static GranteeUnmarshaller INSTANCE;

    @Override
    public Grantee unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Grantee.Builder grantee = Grantee.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DisplayName", targetDepth)) {
                    grantee.displayName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EmailAddress", targetDepth)) {
                    grantee.emailAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ID", targetDepth)) {
                    grantee.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("xsi:type", targetDepth)) {
                    grantee.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("URI", targetDepth)) continue;
                grantee.uri(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Grantee)grantee.build();
    }

    public static GranteeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GranteeUnmarshaller();
        }
        return INSTANCE;
    }
}

