/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;

public class HeadBucketRequestMarshaller
implements Marshaller<Request<HeadBucketRequest>, HeadBucketRequest> {
    @Override
    public Request<HeadBucketRequest> marshall(HeadBucketRequest headBucketRequest) {
        if (headBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<HeadBucketRequest> request = new DefaultRequest<HeadBucketRequest>(headBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.HEAD);
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", headBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

