/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class HeadObjectRequestMarshaller
implements Marshaller<Request<HeadObjectRequest>, HeadObjectRequest> {
    @Override
    public Request<HeadObjectRequest> marshall(HeadObjectRequest headObjectRequest) {
        if (headObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<HeadObjectRequest> request = new DefaultRequest<HeadObjectRequest>(headObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.HEAD);
        if (headObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(headObjectRequest.ifMatch()));
        }
        if (headObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringUtils.fromDate(headObjectRequest.ifModifiedSince()));
        }
        if (headObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringUtils.fromString(headObjectRequest.ifNoneMatch()));
        }
        if (headObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringUtils.fromDate(headObjectRequest.ifUnmodifiedSince()));
        }
        if (headObjectRequest.range() != null) {
            request.addHeader("Range", StringUtils.fromString(headObjectRequest.range()));
        }
        if (headObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString(headObjectRequest.sseCustomerAlgorithm()));
        }
        if (headObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString(headObjectRequest.sseCustomerKey()));
        }
        if (headObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString(headObjectRequest.sseCustomerKeyMD5()));
        }
        if (headObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(headObjectRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", headObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", headObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (headObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(headObjectRequest.versionId()));
        }
        if (headObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger(headObjectRequest.partNumber()));
        }
        return request;
    }
}

