/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LifecycleConfiguration;
import software.amazon.awssdk.services.s3.transform.RuleUnmarshaller;

public class LifecycleConfigurationUnmarshaller
implements Unmarshaller<LifecycleConfiguration, StaxUnmarshallerContext> {
    private static LifecycleConfigurationUnmarshaller INSTANCE;

    @Override
    public LifecycleConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LifecycleConfiguration.Builder lifecycleConfiguration = LifecycleConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Rule", targetDepth)) continue;
                lifecycleConfiguration.rules(RuleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LifecycleConfiguration)lifecycleConfiguration.build();
    }

    public static LifecycleConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LifecycleConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

