/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    @Override
    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListMultipartUploadsRequest> request = new DefaultRequest<ListMultipartUploadsRequest>(listMultipartUploadsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?uploads";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listMultipartUploadsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listMultipartUploadsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString(listMultipartUploadsRequest.delimiter()));
        }
        if (listMultipartUploadsRequest.encodingType() != null) {
            request.addParameter("encoding-type", StringUtils.fromString(listMultipartUploadsRequest.encodingType()));
        }
        if (listMultipartUploadsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringUtils.fromString(listMultipartUploadsRequest.keyMarker()));
        }
        if (listMultipartUploadsRequest.maxUploads() != null) {
            request.addParameter("max-uploads", StringUtils.fromInteger(listMultipartUploadsRequest.maxUploads()));
        }
        if (listMultipartUploadsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString(listMultipartUploadsRequest.prefix()));
        }
        if (listMultipartUploadsRequest.uploadIdMarker() != null) {
            request.addParameter("upload-id-marker", StringUtils.fromString(listMultipartUploadsRequest.uploadIdMarker()));
        }
        return request;
    }
}

