/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListPartsRequestMarshaller
implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {
    @Override
    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {
        if (listPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPartsRequest> request = new DefaultRequest<ListPartsRequest>(listPartsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPartsRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(listPartsRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listPartsRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", listPartsRequest.key());
        request.setResourcePath(uriResourcePath);
        if (listPartsRequest.maxParts() != null) {
            request.addParameter("max-parts", StringUtils.fromInteger(listPartsRequest.maxParts()));
        }
        if (listPartsRequest.partNumberMarker() != null) {
            request.addParameter("part-number-marker", StringUtils.fromInteger(listPartsRequest.partNumberMarker()));
        }
        if (listPartsRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(listPartsRequest.uploadId()));
        }
        return request;
    }
}

