/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.transform.InitiatorUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PartUnmarshaller;
import software.amazon.awssdk.util.DateUtils;

public class ListPartsResponseUnmarshaller
implements Unmarshaller<ListPartsResponse, StaxUnmarshallerContext> {
    private static ListPartsResponseUnmarshaller INSTANCE;

    @Override
    public ListPartsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ListPartsResponse.Builder listPartsResponse = ListPartsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-abort-date");
            listPartsResponse.abortDate(DateUtils.parseRfc822Date(context.readText()));
            context.setCurrentHeader("x-amz-abort-rule-id");
            listPartsResponse.abortRuleId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            listPartsResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    listPartsResponse.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Key", targetDepth)) {
                    listPartsResponse.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UploadId", targetDepth)) {
                    listPartsResponse.uploadId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PartNumberMarker", targetDepth)) {
                    listPartsResponse.partNumberMarker(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NextPartNumberMarker", targetDepth)) {
                    listPartsResponse.nextPartNumberMarker(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxParts", targetDepth)) {
                    listPartsResponse.maxParts(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsTruncated", targetDepth)) {
                    listPartsResponse.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Part", targetDepth)) {
                    listPartsResponse.parts(PartUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Initiator", targetDepth)) {
                    listPartsResponse.initiator(InitiatorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Owner", targetDepth)) {
                    listPartsResponse.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClass", targetDepth)) continue;
                listPartsResponse.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ListPartsResponse)listPartsResponse.build();
    }

    public static ListPartsResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListPartsResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

