/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LoggingEnabled;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.services.s3.transform.TargetGrantUnmarshaller;

public class LoggingEnabledUnmarshaller
implements Unmarshaller<LoggingEnabled, StaxUnmarshallerContext> {
    private static LoggingEnabledUnmarshaller INSTANCE;

    @Override
    public LoggingEnabled unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LoggingEnabled.Builder loggingEnabled = LoggingEnabled.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TargetBucket", targetDepth)) {
                    loggingEnabled.targetBucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetGrants", targetDepth)) {
                    loggingEnabled.targetGrants(new ArrayList<TargetGrant>());
                    continue;
                }
                if (context.testExpression("TargetGrants/Grant", targetDepth)) {
                    loggingEnabled.targetGrants(TargetGrantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TargetPrefix", targetDepth)) continue;
                loggingEnabled.targetPrefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LoggingEnabled)loggingEnabled.build();
    }

    public static LoggingEnabledUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoggingEnabledUnmarshaller();
        }
        return INSTANCE;
    }
}

