/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;

public class NoncurrentVersionExpirationUnmarshaller
implements Unmarshaller<NoncurrentVersionExpiration, StaxUnmarshallerContext> {
    private static NoncurrentVersionExpirationUnmarshaller INSTANCE;

    @Override
    public NoncurrentVersionExpiration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NoncurrentVersionExpiration.Builder noncurrentVersionExpiration = NoncurrentVersionExpiration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("NoncurrentDays", targetDepth)) continue;
                noncurrentVersionExpiration.noncurrentDays(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NoncurrentVersionExpiration)noncurrentVersionExpiration.build();
    }

    public static NoncurrentVersionExpirationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NoncurrentVersionExpirationUnmarshaller();
        }
        return INSTANCE;
    }
}

